exec function testdodge() 
{
	theGame.GetGuiManager().ShowNotification( theGame.GetEntityByTag( 'spells_dodge_effect' ) );
}
exec function testvigil() 
{
	theGame.GetGuiManager().ShowNotification( GetMagicVigil() );
}
exec function testdream() 
{
	theGame.GetGuiManager().ShowNotification( GetMagicDreamer() );
}
/*
exec function anim( n : name )
{
	var sett : SAnimatedComponentSlotAnimationSettings;
	
	sett.blendIn = 1.0f;
	sett.blendOut = 1.0f;

	thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( n, 'PLAYER_SLOT', sett );
}
*/

exec function loads( n : string )
{
		if ( !theSound.SoundIsBankLoaded( n ) )
		{
			theSound.SoundLoadBank( n, false );
		}
}


exec function sound( n : string, optional num : int )
{
	if ( num ==1 )
	{
		GetMagicEffectLeft().Destroy();
	}
	else
	{
		GetMagicEffectLeft().SoundEvent( n );
	}
}


exec function effect( n : name )
{
		thePlayer.PlayEffect( n );
		//fx\signs\aard\charge_release\aard_mesh.w2mesh
		//mutation_energy
		//mutation_10_energy
		//ability_gryphon_active
}

exec function stopef()
{
		thePlayer.StopAllEffects();
}

statemachine class W3MagicVigil extends CGameplayEntity
{
	var i 												: int;
	public var manual_aim_spells         				: array<name>;
	public var signskill 								: ESkill;
	public var spell_item_names_quickslot 				: array<name>;
	public var spell_item_names_trophy                  : array<name>;
	var manual_aim_spell								: name;
	var sett 											: SAnimatedComponentSlotAnimationSettings;
	var signtype 										: ESignType;
	var templatename 									: string;
	var spell_name 										: name;
	var alternate										: bool;
	var collisions_stream 								: array< name >;
	var magic_item_quickslot_name						: name;
	var magic_item_trophy_name							: name;
	var slot_name										: string;
	var hud 											: CR4ScriptedHud;
	var radialModule 									: CR4HudModuleRadialMenu;
	var rad_opened										: bool;
	var spellpower_final								: float;
	var stamina_cost									: float;
	var stamina_delay									: float;
	var hand_aim_direction 								: Vector;
	var hand_aim_position 								: Vector;
	var stream_hits										: array<CGameplayEntity>;	
	var	cannot_play_eff									: bool;
	var actor											: CActor;
	var state_name										: name;
	var check_cast_axii									: bool;
	var checkHeading 									: float;
	var playerToHeadingDist 							: float;
	var actor_attacker									: CActor;
	var is_in_custom_anim								: bool;
	var is_in_custom_anim_sword							: bool;
	var alt 											: int;
	var act_signtype 									: ESignType; 
	var damage_action_vigil								: W3DamageAction;
	var bloom_disabled									: bool;
	var is_inside_energy								: bool;
	var is_inside_veil									: bool;
	var hit_received                                	: bool;
	var slowdown_active									: bool;
	var storm_is_active									: bool;
	var sword_ring_active								: bool;
	var casting_sword_spell								: bool;
	var can_interrupt									: bool;
	var swordeffect_active								: bool;
	var xboweffect_active								: bool;
	var can_cast_rend_lukatiel							: bool;
	var currentsign_sword								: ESignType;
	var currentsign_xbow								: ESignType;
	var deployedentspells								: W3AdvancedProjectile;
	var orig_speed_xbow, orig_angle_xbow				: float;
	var xbow_hand_effect								: name;
	var manual_aiming_active							: bool;
	var is_in_manual_aiming								: bool;
	var dodge_lock										: bool;
	var manual_aim_queue								: int;
	var prevcontextspells								: name;
	var drink_health_val								: float;
	var drink_health_val_act							: float;
	var dodge_effect, dodge_blood_add, dummy			: CEntity;
	var animspeedmult_dodge								: array<int>;
	var animspeedmult_attack							: array<int>;
	var animspeedmult_attack_val						: float;
	var animspeedmult_dodge_val							: float;
	var entities										: array<CEntity>;
	var current_attack 									: EBufferActionType;
	var spelltooltip									: bool;
	var overlayPopupRef  								: CR4OverlayPopup;
	var other_speed_mult								: float;
	var AdvPopupData									: BookPopupFeedback;
	var messageSpells 									: W3TutorialPopupData;
	var chosenString									: string;
	


	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		collisions_stream.Clear();
		collisions_stream.PushBack( 'Static' );		
		collisions_stream.PushBack( 'Door' );
		collisions_stream.PushBack( 'Terrain' );
		collisions_stream.PushBack( 'Dangles' );
		collisions_stream.PushBack( 'Foliage' );
		collisions_stream.PushBack( 'Destructible' );
		collisions_stream.PushBack( 'RigidBody' );
		collisions_stream.PushBack( 'Water' );
		collisions_stream.PushBack( 'Boat' );
		collisions_stream.PushBack( 'BoatDocking' );
		collisions_stream.PushBack( 'Platforms' );
		collisions_stream.PushBack( 'Corpse' );
		collisions_stream.PushBack( 'Projectile' );
		collisions_stream.PushBack( 'ParticleCollider' ); 
		collisions_stream.PushBack( 'Ragdoll' ); 
		
		spell_item_names_quickslot.Clear();
		spell_item_names_quickslot.PushBack( 'weight_tome' );
		spell_item_names_quickslot.PushBack( 'slow_tome' );
		spell_item_names_quickslot.PushBack( 'safe_tome' );
		spell_item_names_quickslot.PushBack( 'distance_tome' );
		spell_item_names_quickslot.PushBack( 'permafrost_tome' );
		spell_item_names_quickslot.PushBack( 'knockdown_tome' );
		spell_item_names_quickslot.PushBack( 'elaxii_tome' );
		spell_item_names_quickslot.PushBack( 'fireyrden_tome' );
		spell_item_names_quickslot.PushBack( 'teleport_tome' );
		spell_item_names_quickslot.PushBack( 'poisonyrden_tome' );
		spell_item_names_quickslot.PushBack( 'fgolem_tome' );
		spell_item_names_quickslot.PushBack( 'igolem_tome' );
		spell_item_names_quickslot.PushBack( 'necro_tome' );
		spell_item_names_quickslot.PushBack( 'ghost_tome' );
		spell_item_names_quickslot.PushBack( 'witch_tome' );
		spell_item_names_quickslot.PushBack( 'black_tome' );
		
		spell_item_names_trophy.Clear();
		spell_item_names_trophy.PushBack( 'gwin_tome' );
		spell_item_names_trophy.PushBack( 'neverwinter_tome' );
		spell_item_names_trophy.PushBack( 'fire2_tome' );
		spell_item_names_trophy.PushBack( 'sword_tome' );
		spell_item_names_trophy.PushBack( 'vampire_tome' );
		spell_item_names_trophy.PushBack( 'spelltome_doll' );
		spell_item_names_trophy.PushBack( 'assassin_tome' );
		spell_item_names_trophy.PushBack( 'aardslow_tome' );
		spell_item_names_trophy.PushBack( 'iceblast_tome' );
		spell_item_names_trophy.PushBack( 'meteorice_tome' );
		spell_item_names_trophy.PushBack( 'meteorfire_tome' );
		spell_item_names_trophy.PushBack( 'invisible_tome' );
		
		
		
		theInput.RegisterListener( this, 'OnCastSpell', 				'CastMagicSpell' );
		theInput.RegisterListener( this, 'OnCastSpellsHold', 			'CastMagicSpellHold' );
		theInput.RegisterListener( this, 'OnStartManualAiming', 		'SpellsManual' );
		theInput.RegisterListener( this, 'OnShootManualAiming',  		'SpellsManualShoot' );
		theInput.RegisterListener( this, 'OnRadialTooltip', 			'Spellshud' );
		theInput.RegisterListener( this, 'OnRadialTooltipAdv', 			'SpellshudHold' );
		


		thePlayer.AddAnimEventChildCallback(this,	'axii_ready',						'OnCastSpellAnimation');
		thePlayer.AddAnimEventChildCallback(this,	'axii_alternate_ready',				'OnCastSpellAnimation');
		thePlayer.AddAnimEventChildCallback(this,	'yrden_draw_ready',					'OnCastSpellAnimation');
		thePlayer.AddAnimEventChildCallback(this,	'cast_begin',						'OnCastSpellAnimation');
		thePlayer.AddAnimEventChildCallback(this,	'cast_throw',						'OnCastSpellAnimation');
		thePlayer.AddAnimEventChildCallback(this,	'cast_end',							'OnCastSpellAnimation');
		thePlayer.AddAnimEventChildCallback(this,	'PerformMagicAttack',				'OnCastSpellAnimationCustom');
		thePlayer.AddAnimEventChildCallback(this,	'Dodge',							'OnDodgeAnimation');
				
		thePlayer.AddAnimEventChildCallback(this,	'BloodTrail',						'OnCastSpellAnimationSword');
		thePlayer.AddAnimEventChildCallback(this,	'FinishSpecialHeavyAttack',			'OnCastSpellSpecialSwordHeavy');
		GetWitcherPlayer().AddAnimEventChildCallback(this,	'ProjectileThrow',					'OnCastSpellProjectileThrow');
		
		
		//  ¯\_(ツ)_/¯
		theGame.SetTimeScale( 0.7 , theGame.GetTimescaleSource(7), theGame.GetTimescalePriority(7));
		theGame.RemoveTimeScale(theGame.GetTimescaleSource(7));
		//  ¯\_(ツ)_/¯
		
		alternate = false;
		
		rad_opened = false;
		spelltooltip = false;
		
		other_speed_mult = 0;
		
		is_in_custom_anim = false;
		is_in_custom_anim_sword = false;
		
		bloom_disabled = false;
		
		is_inside_energy = false;
		
		is_inside_veil = false;
		
		hit_received = false;
		
		slowdown_active = false;
		
		storm_is_active = false;
		
		casting_sword_spell = false;
		
		can_interrupt = false;
		
		manual_aiming_active = false;
		is_in_manual_aiming = false;
		
		swordeffect_active = false;
		xboweffect_active = false;
		
		manual_aim_queue = 0;
		
		can_cast_rend_lukatiel = false;
		
		//AddTimer( 'check_radial_menu', 0.01, true );
		
		//AddTimer( 'debug_slow_yrden', 0.01, true );
		
		sett.blendIn = 1.0f;
		sett.blendOut = 1.0f;
		
		this.GotoState('Vigil_Dreaming');
	}
	
	timer function spells_watch_xbow( deltaTime : float , id : int)
	{
		if ( thePlayer.HasBuff( EET_LukatielSword ) )
		{
			if ( check_bolts_spells() )
			{
				deployedentspells = thePlayer.rangedWeapon.GetDeployedEntity();
			}
		}
		else
		{
			RemoveTimer('spells_watch_xbow');
		}
	}
	
	event OnCastSpellProjectileThrow( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( thePlayer.GetInventory().IsItemCrossbow( thePlayer.GetInventory().GetItemFromSlot('l_weapon') ) )
		{	
			if( thePlayer.HasBuff( EET_LukatielSword ) ) 
			{
				if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'enable_crossbow_effects') )
				{
					crossbow_shoot_lukatiel(deployedentspells);
				}
			}
		}
	}
	
	event OnCastSpellSpecialSwordHeavy( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventType == AET_DurationStart )
		{	
			if( thePlayer.HasBuff( EET_LukatielSword ) ) 
			{
				signtype = GetWitcherPlayer().GetEquippedSign();
				create_sword_rend_n_spells_effects( signtype, 1.7 );
				can_cast_rend_lukatiel = true;
			}
		}
	}
	
	
	event OnCbtDodgeSpells( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			if ( can_interrupt_custom() )
			{
				thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( '', 'PLAYER_SLOT' );
				this.PushState( 'Vigil_Dreaming' );
				this.AddTimer( 'spells_dodge', 0.01f);
			}
			
			if ( alternate )
			{
				this.PushState( 'Vigil_Dreaming' );
				this.AddTimer( 'spells_dodge', 0.01f);
			}
		}
	}
	
	event OnCbtRollSpells( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			if ( can_interrupt_custom() )
			{
				thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( '', 'PLAYER_SLOT' );
				this.PushState( 'Vigil_Dreaming' );
				this.AddTimer( 'spells_roll', 0.01f);
			}
		
			if ( alternate )
			{
				this.PushState( 'Vigil_Dreaming' );
				this.AddTimer( 'spells_roll', 0.01f);
			}
		}
	}
	
	event OnLockAndGuardSpells( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			if ( alternate || can_interrupt_custom() )
			{
				if ( is_in_custom_anim )
				{
					thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( '', 'PLAYER_SLOT' );
				}
				
				this.PushState( 'Vigil_Dreaming' );
				
				if ( thePlayer.bLAxisReleased )
					thePlayer.ResetRawPlayerHeading();
				
				thePlayer.AddCounterTimeStamp(theGame.GetEngineTime());	
				thePlayer.SetGuarded(true);				
				thePlayer.OnPerformGuard();
			}
		}
	}
	
	event OnCbtAttackLightSpells( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			if ( can_interrupt_custom() || alternate )
			{
				//theGame.witcherLog.AddMessage("OnCbtAttackLightSpells");
			
				thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( '', 'PLAYER_SLOT' );
				this.PushState( 'Vigil_Dreaming' );
				this.AddTimer( 'spells_attacklight', 0.01f);
			}
		}
	}
	event OnCbtAttackLightSpells2( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			if ( can_interrupt_custom() || alternate )
			{
				//theGame.witcherLog.AddMessage("OnCbtAttackLightSpells2");
			
				thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( '', 'PLAYER_SLOT' );
				this.PushState( 'Vigil_Dreaming' );
				this.AddTimer( 'spells_attacklight', 0.01f);
			}
		}
	}
	timer function spells_attacklight( deltaTime : float , id : int)
	{
		thePlayer.SetupCombatAction( EBAT_LightAttack, BS_Pressed );
	}
	
	event OnCbtAttackHeavySpells( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			if ( can_interrupt_custom() || alternate )
			{
				thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( '', 'PLAYER_SLOT' );
				this.PushState( 'Vigil_Dreaming' );
				this.AddTimer( 'spells_attackheavy', 0.01f);
			}
		}
	}
	event OnCbtAttackHeavySpells2( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			if ( can_interrupt_custom() || alternate )
			{
				thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( '', 'PLAYER_SLOT' );
				this.PushState( 'Vigil_Dreaming' );
				this.AddTimer( 'spells_attackheavy', 0.01f);
			}
		}
	}
	timer function spells_attackheavy( deltaTime : float , id : int)
	{
		thePlayer.SetupCombatAction( EBAT_HeavyAttack, BS_Released );			
	}
	
	
	event OnCastSpellAnimationCustom( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
	}
	
	
	event OnDodgeAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventType == AET_DurationStart )
		{	
			//theGame.witcherLog.AddMessage("Dodge Start");
			
			check_special_dodges();
			
			if ( is_in_custom_anim )
			{
				//theGame.witcherLog.AddMessage("Dodge Start  is_in_custom_anim ");
				
				this.GotoState( 'Vigil_Dreaming' );
				thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( '', 'PLAYER_SLOT' );
				if( theInput.IsActionPressed( 'CbtRoll' ) )
				{
					this.AddTimer( 'spells_roll', 0.01f);
				}
				if( theInput.IsActionPressed( 'Dodge' ) )
				{
					this.AddTimer( 'spells_dodge', 0.01f);
				}
			}
		}
		if ( animEventType == AET_DurationEnd )
		{	
			//theGame.witcherLog.AddMessage("Dodge End ANIMEVENT");
			special_dodges_cancel();
		}
	}
	timer function spells_roll( deltaTime : float , id : int)
	{
		thePlayer.EvadePressed(EBAT_Roll);
	}
	timer function spells_dodge( deltaTime : float , id : int)
	{
		thePlayer.EvadePressed(EBAT_Dodge);
	}
	
	event OnCastSpell( action : SInputAction )
	{
		var casthold : SInputAction;
		
		if ( IsPressed(action) && manual_aiming_active && is_in_manual_aiming )
		{
			ManualAimingSwitch();
		}
		
		casthold = theInput.GetAction('CastMagicSpellHold');
		
		if ( IsReleased(action) && casthold.value < 0.7 && casthold.lastFrameValue < 0.7 )
		{
			if ( is_in_custom_anim /*&& state_name == 'SwordRingSpells'*/ && can_interrupt )
			{
				if ( Spells_get_spell_info( magic_item_quickslot_name, spell_name, signskill, alternate, act_signtype, alt, state_name ) )
				{
					thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( '', 'PLAYER_SLOT' );
					PushState('Vigil_Dreaming');
					GetMagicDreamer().PushState('Dreamer_Waiting');
					AddTimer( 'casssst', 0.01f);
				}
			}
			else
			if ( alternate )
			{
				PushState('Vigil_Dreaming');
			}
			else
			if ( spell_cast_allowed() )
			{
				process_magic_spells_quickslot();
				//theGame.witcherLog.AddMessage("original cast    "  );

			}
		}
	}
	timer function casssst( deltaTime : float , id : int)
	{
		if ( spell_cast_allowed() )
		{
			process_magic_spells_quickslot();
				//theGame.witcherLog.AddMessage("second cast    "  );
		}
	}
	
	
	event OnCastSpellsHold( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			
			if ( is_in_custom_anim /*&& state_name == 'SwordRingSpells'*/ && can_interrupt )
			{
				if ( Spells_get_spell_info_trophy( get_magic_item_trophy(), spell_name, signskill, alternate, act_signtype, alt, state_name ) )
				{
					thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( '', 'PLAYER_SLOT' );
					PushState('Vigil_Dreaming');
					AddTimer( 'casssssssst', 0.01f);
				}
			}
			else
			if ( alternate )
			{
				PushState('Vigil_Dreaming');
			}
			else
			if ( spell_cast_allowed() )
			{
				process_magic_spells_trophy();
			}
		}
	}
	timer function casssssssst( deltaTime : float , id : int)
	{
		if ( spell_cast_allowed() )
		{
			process_magic_spells_trophy();
		}
	}

	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		var quen : W3QuenEntity;
		
	
		if ( animEventName == 'cast_end' || animEventName == 'cast_throw' )
		{
			quen = (W3QuenEntity)GetWitcherPlayer().GetSignEntity(ST_Quen);
			if(quen)
			{	
				clear_guarding_buffs( true );	
			}
		}
	
	}
	
	event OnDestroyed()
	{
	}

	timer function debug_slow_yrden( deltaTime : float , id : int)
	{
		var l_i 				: int;
		var yrdenEntities1 		:  array<W3YrdenEntity>;
		
		yrdenEntities1 = GetWitcherPlayer().yrdenEntities;
		
		for( l_i = 0 ; l_i < yrdenEntities1.Size() ; l_i += 1 )
		{
			if( yrdenEntities1[ l_i ].GetIsPlayerInside() )
			{
				if ( !slowdown_active )
				{
					theGame.SetTimeScale(0.6, theGame.GetTimescaleSource(7), theGame.GetTimescalePriority(7));
					theGame.RemoveTimeScale(theGame.GetTimescaleSource(7));
					theGame.SetTimeScale(0.6, theGame.GetTimescaleSource(7), theGame.GetTimescalePriority(7));
					
					slowdown_active = true;
				}
			}
			else
			{
				if ( slowdown_active )
				{
					theGame.RemoveTimeScale(theGame.GetTimescaleSource(7));
					slowdown_active = false;
				}
			}
		}
	}

	//timer function check_radial_menu( deltaTime : float , id : int)
	
	public function set_can_interrupt( value : bool )
	{
		can_interrupt = value;
	}

	public function set_is_in_custom_anim_sword( value : bool )
	{
		is_in_custom_anim_sword = value;
	}

	public function set_is_in_custom_anim( value : bool )
	{
		is_in_custom_anim = value;
		if ( value )
		{
			//thePlayer.PushState('Vigil_watching_animation');
		}
		else
		{
			if ( thePlayer.GetCurrentStateName() == 'Vigil_watching_animation' )
			{
				//theGame.witcherLog.AddMessage("POP STATE");
				//thePlayer.PopState();
			}
		}
	}

	public function set_casting_sword_spell( value : bool )
	{
		casting_sword_spell = value;
	}
	
	public function set_inside_energy( value : bool )
	{
		is_inside_energy = value;
	}
	
	public function set_inside_veil( value : bool )
	{
		is_inside_veil = value;
	}
	
	public function set_storm( value : bool )
	{
		storm_is_active = value;
	}
	
	
	/*
	public function set_hit_received( value : bool )
	{
		hit_received = value;
	}
	
	*/
	public function set_magic_spellpower( value : float )
	{
		spellpower_final = value;
	}
	
	public function get_magic_spellpower() : float
	{
		return spellpower_final;
	}
	
	public function get_quickslot_item_names() : array<name>
	{
		return spell_item_names_quickslot;
	}
	
	public function get_trophy_item_names() : array<name>
	{
		return spell_item_names_trophy;
	}

	function closetooltip()
	{
		if ( spelltooltip )
		{
			spelltooltip = false;
			
			overlayPopupRef = (CR4OverlayPopup)theGame.GetGuiManager().GetPopup('OverlayPopup');
			if ( overlayPopupRef )
			{
				overlayPopupRef.HideNotification();
			}
		}
	}
	function closeAdvtolltip()
	{
		if ( messageSpells )
		{
			messageSpells.CloseTutorialPopup();
		}
	}
	function check_radial_menu()
	{
		hud = (CR4ScriptedHud)theGame.GetHud();
		radialModule = (CR4HudModuleRadialMenu)hud.GetHudModule("RadialMenuModule");
		if ( radialModule.IsRadialMenuOpened() )
		{
			//if ( !rad_opened )
			//{
			//	theGame.witcherLog.AddMessage("ShowRadialMenu");
			//}
			//rad_opened = true;
		}
		else 
		{
			rad_opened = false;
			
			closetooltip();
			
			closeAdvtolltip();
		}
	}
	event OnRadialTooltip( action : SInputAction )
	{
		var casthold : SInputAction;
		
		casthold = theInput.GetAction('SpellshudHold');
		
		if (  IsReleased(action) && casthold.value < 0.7 && casthold.lastFrameValue < 0.7 )
		{
			if ( !spelltooltip )
			{
				show_spell_tooltip();
				spelltooltip = true;
			}
			else
			{
				closetooltip();
			}
		}
	}
	event OnRadialTooltipAdv( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			if ( !messageSpells )
			{
				closetooltip();
				show_spell_advanced_tooltip();
			}
			else
			{
				closeAdvtolltip();
			}
		}
	}
	
	
	public function spells_show_radial_menu()
	{
		rad_opened = true;
	}
	public function spells_radial_menu_slot( chosen : string )
	{
		var item		 	: SItemUniqueId;
		var prevname		: name;
		var prevsign		: string;
		
		prevname = magic_item_quickslot_name;
		prevsign = chosenString;
		
		slot_name = chosen;
		if ( slot_name == "Slot3" )
		{
			GetWitcherPlayer().GetItemEquippedOnSlot( EES_Quickslot1, item );
			if ( spell_item_names_quickslot.Contains( thePlayer.GetInventory().GetItemName( item ) ) )
			{
				magic_item_quickslot_name = thePlayer.GetInventory().GetItemName( item );
			}
		}
		if ( slot_name == "Slot4" )
		{
			GetWitcherPlayer().GetItemEquippedOnSlot( EES_Quickslot2, item );
			if ( spell_item_names_quickslot.Contains( thePlayer.GetInventory().GetItemName( item ) ) )
			{
				magic_item_quickslot_name = thePlayer.GetInventory().GetItemName( item );
			}
		}
		if ( prevname != magic_item_quickslot_name && spelltooltip ) 
		{
			show_spell_tooltip();
		}
		
		/*
		if ( prevname != magic_item_quickslot_name && messageSpells ) 
		{
			show_spell_advanced_tooltip();
		}
		*/
		
		if ( chosen == "Aard"  )  { chosenString = "Aard";  }
		else if ( chosen == "Axii"  )  { chosenString = "Axii";  }
		else if ( chosen == "Quen"  )  { chosenString = "Quen";  }
		else if ( chosen == "Igni"  )  { chosenString = "Igni";  }
		else if ( chosen == "Yrden" )  { chosenString = "Yrden"; }
		else if ( chosen == "Slot3" || chosen == "Slot4" )  { chosenString = "QuickSlot"; }
		else { chosenString = "none"; }
		
		if ( prevsign != chosenString && messageSpells )
		{
			show_spell_advanced_tooltip();
		}
		
		//theGame.GetGuiManager().ShowNotification( chosen, 9000000 );
	}	
	
	public function get_signskill_spells() : ESkill
	{
		return signskill;
	}
	
	public function damage_taken( attacker : CActor, dmgact : W3DamageAction )
	{
		if ( is_in_manual_aiming )
		{
			clean_manual_aiming();
		}
		
		actor_attacker = attacker;
		damage_action_vigil = dmgact;
		PushState( 'Vigil_Nightmare' );
		GetMagicDreamer().PushState('Dreamer_Waiting');
	}

	function process_magic_spells_quickslot()
	{
		signtype = GetWitcherPlayer().GetEquippedSign();
		
		if ( get_magic_item_quickslot() != 'empty' )
		{
			magic_item_quickslot_name = get_magic_item_quickslot();
		}
		
		if ( GetWitcherPlayer().IsItemEquippedByName( magic_item_quickslot_name ) )
		{
			if ( Spells_get_spell_info( magic_item_quickslot_name, spell_name, signskill, alternate, act_signtype, alt, state_name ) )
			{
				signtype = GetWitcherPlayer().GetEquippedSign();
				spellpower_final = get_spellpower_spells( false, signskill );
				//theGame.witcherLog.AddMessage("Sign SKILL  " + (string)signskill );
				//theGame.witcherLog.AddMessage("Spellpower Final  " + spellpower_final );
				this.GotoState( 'Vigil_Casting' );
			}
		}
	}

	function process_magic_spells_trophy()
	{
		
		if ( Spells_get_spell_info_trophy( get_magic_item_trophy(), spell_name, signskill, alternate, act_signtype, alt, state_name ) )
		{
			signtype = GetWitcherPlayer().GetEquippedSign();
			spellpower_final = get_spellpower_spells( false, signskill );
			//theGame.witcherLog.AddMessage("Sign SKILL  " + (string)signskill );
			//theGame.witcherLog.AddMessage("Spellpower Final  " + spellpower_final );
			this.GotoState( 'Vigil_Casting' );
		}
	}


	public function IsAlt() : Bool
	{
		return alternate;
	}
	
	public function Spells_get_hand_pos() : Vector
	{
		return hand_aim_position;
	}
	
	public function Spells_get_hand_aim() : Vector
	{
		return hand_aim_direction;
	}
	
	timer function spells_enable_bloom( deltaTime : float , id : int)
	{
		if ( thePlayer.GetBehaviorVariable	( 'IsCastingSign' ) != 1 )
		{
			bloom_disabled = false;
			theGame.GetInGameConfigWrapper().SetVarValue('PostProcess', 'AllowBloom', "true" );
		}
	}
	
	timer function rotate_towards_target( deltaTime : float , id : int)
	{
		var movementAdjustor 														: CMovementAdjustor;
		var ticket_spell	 														: SMovementAdjustmentRequestTicket;	
		
		movementAdjustor = thePlayer.GetMovingAgentComponent().GetMovementAdjustor();
		ticket_spell = movementAdjustor.CreateNewRequest( 'Spells_rotation');
		movementAdjustor.MaxRotationAdjustmentSpeed( ticket_spell, 500 );
		movementAdjustor.MaxLocationAdjustmentSpeed( ticket_spell, 500 );
		movementAdjustor.RotateTowards( ticket_spell, actor );
	}
	
	timer function rotate_towards_camera( deltaTime : float , id : int)
	{
		var movementAdjustor 														: CMovementAdjustor;
		var ticket_spell	 														: SMovementAdjustmentRequestTicket;	
		
		movementAdjustor = thePlayer.GetMovingAgentComponent().GetMovementAdjustor();
		ticket_spell = movementAdjustor.CreateNewRequest( 'Spells_rotation');
		movementAdjustor.MaxRotationAdjustmentSpeed( ticket_spell, 500 );
		movementAdjustor.MaxLocationAdjustmentSpeed( ticket_spell, 500 );
		movementAdjustor.RotateTo( ticket_spell, VecHeading( theCamera.GetCameraDirection() ) );
	}
	
	timer function destroy_summoned_stone_golem( deltaTime : float , id : int)
	{
		destroy_stone_golems();
	}
	function destroy_stone_golems()
	{
		var ents_destroy									: array< CEntity >;
		var acts_destroy									: array< CActor >;
		var i 												: int;
		var portal											: CEntity;
		var pos 											: Vector;
		
		//theGame.witcherLog.AddMessage("destroy_summoned_stone_golem");
		theGame.GetEntitiesByTag('spells_stone_golem', ents_destroy );
		for( i=0; i<ents_destroy.Size(); i+=1 )
		{
			pos = ents_destroy[i].GetWorldPosition();
			pos.Z += 1;
			portal = theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\portal_for_golems.w2ent", true ), pos );
			portal.PlayEffect('teleport');
			portal.StopAllEffects();
			portal.DestroyAfter( 1 );
			ents_destroy[i].Destroy();
		} 	
		RemoveTimer( 'evaluate_targets_for_stone_golem' );
	}
	timer function evaluate_targets_for_stone_golem( deltaTime : float , id : int)
	{
		var actors											: array< CActor >;
		var golem 											: CNewNPC;
		var i 												: int;
		
		golem = theGame.GetNPCByTag('spells_stone_golem_npc');
		actors = golem.GetNPCsAndPlayersInRange( 20, 100, , FLAG_OnlyAliveActors );
		for( i = 0; i < actors.Size(); i += 1 )
		{
			if ( IsRequiredAttitudeBetween(thePlayer, actors[i], true, false, false) )
			{ 
				actors[i].SetAttitude( golem, AIA_Hostile ); 
				golem.SetAttitude( actors[i], AIA_Hostile ); 
			}
			else
			{ 
				golem.SetAttitude( actors[i], AIA_Friendly ); 
			}
		}
	}
	
	
	timer function destroy_summoned_ice_golem( deltaTime : float , id : int)
	{
		destroy_ice_golems();
	}
	function destroy_ice_golems()
	{
		var ents_destroy									: array< CEntity >;
		var acts_destroy									: array< CActor >;
		var i 												: int;
		var portal											: CEntity;
		var pos 											: Vector;
		
		//theGame.witcherLog.AddMessage("destroy_summoned_ice_golem");
		theGame.GetEntitiesByTag('spells_ice_golem', ents_destroy );
		for( i=0; i<ents_destroy.Size(); i+=1 )
		{
			pos = ents_destroy[i].GetWorldPosition();
			pos.Z += 1;
			portal = theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\portal_for_golems.w2ent", true ), pos );
			portal.PlayEffect('teleport');
			portal.StopAllEffects();
			portal.DestroyAfter( 1 );
			ents_destroy[i].Destroy();
		} 	
		RemoveTimer( 'evaluate_targets_for_ice_golem' );
	}
	timer function evaluate_targets_for_ice_golem( deltaTime : float , id : int)
	{
		var actors											: array< CActor >;
		var golem 											: CNewNPC;
		var i 												: int;
		
		golem = theGame.GetNPCByTag('spells_ice_golem_npc');
		actors = golem.GetNPCsAndPlayersInRange( 20, 100, , FLAG_OnlyAliveActors );
		for( i = 0; i < actors.Size(); i += 1 )
		{
			if ( IsRequiredAttitudeBetween(thePlayer, actors[i], true, false, false) )
			{ 
				actors[i].SetAttitude( golem, AIA_Hostile ); 
				golem.SetAttitude( actors[i], AIA_Hostile ); 
			}
			else
			{ 
				golem.SetAttitude( actors[i], AIA_Friendly ); 
			}
		}
	}
	
	timer function destroy_summoned_fire_golem( deltaTime : float , id : int)
	{
		destroy_fire_golems();
	}
	function destroy_fire_golems()
	{
		var ents_destroy									: array< CEntity >;
		var acts_destroy									: array< CActor >;
		var i 												: int;
		var portal											: CEntity;
		var pos 											: Vector;
		
		//theGame.witcherLog.AddMessage("destroy_summoned_fire_golem");
		theGame.GetEntitiesByTag('spells_fire_golem', ents_destroy );
		for( i=0; i<ents_destroy.Size(); i+=1 )
		{
			pos = ents_destroy[i].GetWorldPosition();
			pos.Z += 1;
			portal = theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\portal_for_golems.w2ent", true ), pos );
			portal.PlayEffect('teleport');
			portal.StopAllEffects();
			portal.DestroyAfter( 1 );
			ents_destroy[i].Destroy();
		} 	
		RemoveTimer( 'evaluate_targets_for_fire_golem' );
	}
	timer function evaluate_targets_for_fire_golem( deltaTime : float , id : int)
	{
		var actors											: array< CActor >;
		var golem 											: CNewNPC;
		var i 												: int;
		
		golem = theGame.GetNPCByTag('spells_fire_golem_npc');
		actors = golem.GetNPCsAndPlayersInRange( 20, 100, , FLAG_OnlyAliveActors );
		for( i = 0; i < actors.Size(); i += 1 )
		{
			if ( IsRequiredAttitudeBetween(thePlayer, actors[i], true, false, false) )
			{ 
				actors[i].SetAttitude( golem, AIA_Hostile ); 
				golem.SetAttitude( actors[i], AIA_Hostile ); 
			}
			else
			{ 
				golem.SetAttitude( actors[i], AIA_Friendly ); 
			}
		}
	}
	
	timer function destroy_summoned_panther( deltaTime : float , id : int)
	{
		destroy_panthers();
	}
	function destroy_panthers()
	{
		var ents_destroy									: array< CEntity >;
		var acts_destroy									: array< CActor >;
		var i 												: int;
		var portal											: CEntity;
		var pos 											: Vector;
		
		//theGame.witcherLog.AddMessage("destroy_summoned_fire_golem");
		theGame.GetEntitiesByTag('spells_panther', ents_destroy );
		for( i=0; i<ents_destroy.Size(); i+=1 )
		{
			pos = ents_destroy[i].GetWorldPosition();
			pos.Z += 0.5;
			portal = theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\portal_for_golems.w2ent", true ), pos );
			portal.PlayEffect('teleport');
			portal.StopAllEffects();
			portal.DestroyAfter( 1 );
			ents_destroy[i].Destroy();
		} 	
		RemoveTimer( 'evaluate_targets_for_panther' );
	}
	timer function evaluate_targets_for_panther( deltaTime : float , id : int)
	{
		var actors											: array< CActor >;
		var golem 											: CNewNPC;
		var i 												: int;
		
		golem = theGame.GetNPCByTag('spells_panther_npc');
		actors = golem.GetNPCsAndPlayersInRange( 20, 100, , FLAG_OnlyAliveActors );
		for( i = 0; i < actors.Size(); i += 1 )
		{
			if ( IsRequiredAttitudeBetween(thePlayer, actors[i], true, false, false) )
			{ 
				actors[i].SetAttitude( golem, AIA_Hostile ); 
				golem.SetAttitude( actors[i], AIA_Hostile ); 
			}
			else
			{ 
				golem.SetAttitude( actors[i], AIA_Friendly ); 
			}
		}
	}
	
	function create_sword_standard_effects()
	{
		var templatename2 	: string;
		var n 				: float;
		var lenght			: float;
		var rotation		: EulerAngles;
		var to_destroy		: array< CEntity >;
		var to_destroy2		: array< CEntity >;
		var effects			: array< CEntity >;
		var i				: int;
		var euler_sword		: EulerAngles;
		var swordeffect		: CEntity;

		if( thePlayer.HasBuff( EET_LukatielSword ) && is_holding_sword_spells() 
				&& !GetMagicVigil().is_inside_energy && !thePlayer.GetWeaponHolster().IsOnTheMiddleOfHolstering() 
				&& !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'disable_effects_on_sword')  
				&& !GetMagicVigil().is_inside_veil
				) 
		{
			templatename2 = "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\sword_standard_effects.w2ent";
			
			if ( !theGame.GetEntityByTag( 'sword_ring_standard_effects' ) )
			{
				
				swordeffect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( templatename2, true), thePlayer.GetWorldPosition() );
				swordeffect.CreateAttachment( thePlayer, 'r_weapon' , Vector( 0, 0, 0.5 ) );
				swordeffect.AddTag('sword_ring_standard_effects');
				swordeffect.AddTag('sword_ring_standard_effects_default');
				
				euler_sword.Roll = -90; euler_sword.Pitch = 0; euler_sword.Yaw = -90; 
				for( n = 0.3; n <= 1.f; n += 0.2 )
				{	
					swordeffect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( templatename2, true), thePlayer.GetWorldPosition() );
					swordeffect.CreateAttachment( thePlayer, 'r_weapon', Vector( 0.03, 0, 1*n ), euler_sword );
					swordeffect.AddTag('sword_ring_standard_effects_add_yrd');
					swordeffect.AddTag('sword_ring_standard_effects');
				}
				
				euler_sword.Roll = 90; euler_sword.Pitch = 0; euler_sword.Yaw = -90; 
				for( n = 0.15; n <= 0.8f; n += 0.2 )
				{	
					swordeffect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( templatename2, true), thePlayer.GetWorldPosition() );
					swordeffect.CreateAttachment( thePlayer, 'r_weapon' , Vector( 0.06, 0, 1*n ), euler_sword );
					swordeffect.AddTag('sword_ring_standard_effects_add_yrd');
					swordeffect.AddTag('sword_ring_standard_effects');
				}
			}
		
			if ( swordeffect_active && dodge_lock )
			{
				swordeffect_active = false;
				
				theGame.GetEntityByTag( 'lukatiel_sword_trails' ).StopAllEffects();
				
				theGame.GetEntitiesByTag('sword_ring_standard_effects', to_destroy );
				for( i=0; i<to_destroy.Size(); i+=1 )
				{
					to_destroy[i].DestroyAllEffects();
				}
			}
		
			if ( currentsign_sword != GetWitcherPlayer().GetEquippedSign() )
			{
				swordeffect_active = false;
				
				theGame.GetEntitiesByTag('sword_ring_standard_effects', to_destroy );
				for( i=0; i<to_destroy.Size(); i+=1 )
				{
					to_destroy[i].StopAllEffects();
				}
			}
			currentsign_sword = GetWitcherPlayer().GetEquippedSign();
			
			if ( !swordeffect_active && !dodge_lock )
			{
				switch( currentsign_sword )
				{
					case ST_Igni:
						{
							thePlayer.SoundEvent("fx_rune_activate_igni");
							theGame.GetEntityByTag( 'sword_ring_standard_effects_default' ).PlayEffectSingle('igni');
							swordeffect_active = true;
						}
						break;
				
					case ST_Axii:
						{
							thePlayer.SoundEvent("fx_rune_activate_igni");
							theGame.GetEntityByTag( 'sword_ring_standard_effects_default' ).PlayEffectSingle('axii');
							swordeffect_active = true;
						}
						break;
					
					case ST_Aard:
						{
							thePlayer.SoundEvent("fx_rune_activate_aard");
							theGame.GetEntityByTag( 'sword_ring_standard_effects_default' ).PlayEffectSingle('aard');
							swordeffect_active = true;
						}
						break;
					
					case ST_Quen:
						{
							thePlayer.SoundEvent("fx_rune_activate_igni");
							theGame.GetEntityByTag( 'sword_ring_standard_effects_default' ).PlayEffectSingle('quen');
							swordeffect_active = true;
						}
						break;
					
					case ST_Yrden:
						{
							thePlayer.SoundEvent("fx_rune_activate_yrden");
							theGame.GetEntityByTag( 'sword_ring_standard_effects_default' ).PlayEffectSingle('yrden');
							
							theGame.GetEntitiesByTag('sword_ring_standard_effects_add_yrd', effects );
							for( i=0; i<to_destroy.Size(); i+=1 )
							{
								effects[i].PlayEffectSingle('yrden_electricity');
							}				
							
							swordeffect_active = true;
						}
						break;
						
					default:		
						break;
				}
			}
		}
		else
		{
			theGame.GetEntitiesByTag('sword_ring_standard_effects', to_destroy );
			for( i=0; i<to_destroy.Size(); i+=1 )
			{
				to_destroy[i].RemoveTag( 'sword_ring_standard_effects' );
				to_destroy[i].RemoveTag( 'sword_ring_standard_effects_default' );
				to_destroy[i].StopAllEffects();
				to_destroy[i].DestroyAfter(5);
				to_destroy[i].BreakAttachment();
			}
			swordeffect_active = false;
		}
		
		if ( thePlayer.HasBuff( EET_LukatielSword ) && check_bolts_spells( true ) && theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'enable_crossbow_effects') )
		{
			if ( currentsign_xbow != GetWitcherPlayer().GetEquippedSign() )
			{
				xboweffect_active = false;
				GetMagicEffectLeft().StopEffect( xbow_hand_effect );
			}
			currentsign_xbow = GetWitcherPlayer().GetEquippedSign();
			
			if ( !xboweffect_active )
			{
				switch( currentsign_xbow )
				{
					case ST_Igni:
						{
							xbow_hand_effect = 'igni';
						}
						break;
				
					case ST_Axii:
						{
							xbow_hand_effect = 'axii';
						}
						break;
					
					case ST_Aard:
						{
							xbow_hand_effect = 'aard';
						}
						break;
					
					case ST_Quen:
						{
							xbow_hand_effect = 'quen';
						}
						break;
					
					case ST_Yrden:
						{
							xbow_hand_effect = 'yrden';
						}
						break;
						
					default:		
						break;
				}
				
				GetMagicEffectLeft().PlayEffect( xbow_hand_effect );
				xboweffect_active = true;
			}
		}
		else
		{
			GetMagicEffectLeft().StopEffect( xbow_hand_effect );
			xboweffect_active = false;
		}
		
		if ( theGame.GetEntityByTag('spells_veil_sword') && is_holding_sword_spells() )
		{
			if ( is_inside_energy )
			{
				theGame.GetEntityByTag('spells_veil_sword').StopAllEffects();
			}
			else if ( is_inside_veil && !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'disable_effects_on_sword') && !dodge_lock )
			{
				theGame.GetEntityByTag('spells_veil_sword').PlayEffectSingle('sword_veil');
			}
			else
			{
				theGame.GetEntityByTag('spells_veil_sword').StopAllEffects();
			}
			
			if ( dodge_lock )
			{
				theGame.GetEntityByTag('spells_veil_sword').StopAllEffects();
				theGame.GetEntityByTag('spells_veil_sword').DestroyEffect('sword_veil');
			}
		}
	}

	function check_manual_aiming()
	{
		if ( get_magic_item_quickslot() != 'empty' )
		{
			if ( !manual_aiming_active )
			{
				manual_aiming_active = true;
			}
		}
		else
		{
			if ( manual_aiming_active )
			{
				manual_aiming_active = false;
			}
		}
	}
	
	event OnStartManualAiming( action : SInputAction )
	{
		var size : int;
		
		manual_aim_spells.Clear();
		check_ma_spells();
		size = manual_aim_spells.Size();
		
		if ( IsPressed(action) && manual_aiming_active && !is_in_manual_aiming && spell_manual_aiming_allowed() && size >0 )
		{
			if ( GetWitcherPlayer().OnRaiseSignEvent() )
			{
				thePlayer.BlockAction(EIAB_Parry,'spells_aiming');
			
				is_in_manual_aiming = true;
			
				act_signtype = ST_Igni;
			
				thePlayer.SetBehaviorVariable	( 'alternateSignCast', 1 );
				thePlayer.SetBehaviorVariable	( 'SignNum', (int)ST_Igni );
				thePlayer.SetBehaviorVariable	( 'IsCastingSign', 1 );
				
				thePlayer.playerAiming.StartAiming(NULL);
				thePlayer.PushState( 'camera_hack' ); 
				
				prevcontextspells = theInput.GetContext();
				theInput.SetContext( 'ThrowHoldSpellsss' );
				
				if ( manual_aim_queue >= size )
				{
					manual_aim_queue = 0;
				}
				manual_aim_spell = manual_aim_spells[manual_aim_queue];
				
				create_ma_hand_effects();
				
				//theGame.witcherLog.AddMessage("START MANUAL");
			}
		}
		
		if ( IsReleased(action) && is_in_manual_aiming )
		{
			clean_manual_aiming();
		}
	}
	
	function ManualAimingSwitch()
	{	
		var size 			: int;
		var prevspell		: name;
	
		prevspell = manual_aim_spell;
	
		size = manual_aim_spells.Size();
		manual_aim_queue += 1;
		if ( manual_aim_queue >= size )
		{
			manual_aim_queue = 0;
		}
		
		manual_aim_spell = manual_aim_spells[manual_aim_queue];
		
		if ( prevspell != manual_aim_spell )
		{
			create_ma_hand_effects();
		}
	}
	
	event OnShootManualAiming( action : SInputAction )
	{
		if ( IsPressed(action) && manual_aiming_active && is_in_manual_aiming )
		{	
			//theGame.witcherLog.AddMessage("SPELL  =  " + manual_aim_spell );
			shoot_ma_hand_spells();
		}
	}
	
	function add_ma_spell( spell : name )
	{	
		manual_aim_spells.PushBack(spell);
	}
	
	function clean_manual_aiming()
	{	
		is_in_manual_aiming = false;
		thePlayer.PopState();   
		
		thePlayer.SetBehaviorVariable( 'alternateSignCast', 0 );
		thePlayer.SetBehaviorVariable( 'IsCastingSign', 0 );
		
		theInput.SetContext( prevcontextspells );
		
		GetMagicAim().StopAllEffects();
		GetMagicAim().DestroyAfter(3);
		GetMagicAim().RemoveTag('magic_spell_aim_effect');
		
		GetMagicShoot().StopAllEffects();
		GetMagicShoot().DestroyAfter(3);
		GetMagicShoot().RemoveTag('magic_spell_shoot_effect');
		
		AddTimer( 'unblock_parry_hack', 0.2 );
		//theGame.witcherLog.AddMessage("END MANUAL");
	}
	timer function unblock_parry_hack( deltaTime : float , id : int)
	{
		thePlayer.UnblockAction(EIAB_Parry,'spells_aiming');
	}
	
	function drinkhealth( val : float )
	{	
		drink_health_val = val;
		drink_health_val_act = drink_health_val * 0.04;
		AddTimer('drink_health_proc', 0.1, true );
	}
	timer function drink_health_proc( deltaTime : float , id : int)
	{
		if ( drink_health_val >0 )
		{
			GetWitcherPlayer().GainStat( BCS_Vitality, drink_health_val_act );
			drink_health_val -= drink_health_val_act;
		}
		else
		{
			RemoveTimer('drink_health_proc');
		}
	}
	
	function check_special_dodges()
	{	
		if ( GetWitcherPlayer().GetHorseManager().IsItemEquippedByName( 'vampire_tome' ) )
		{
			if ( !theSound.SoundIsBankLoaded("monster_dettlaff_vampire.bnk") )
			{
				theSound.SoundLoadBank( "monster_dettlaff_vampire.bnk", false );
			}
		
			if ( !dodge_lock )
			{
				if ( animspeedmult_dodge.Size() == 0 )
				{
					animspeedmult_dodge_val = 1.5;
					if ( other_speed_mult !=0 )
					{
						theGame.GetEntityByTag('storm_eye_effect').DestroyEffect('storm_eye');
						animspeedmult_dodge_val += other_speed_mult - 1;
					}
				
					animspeedmult_dodge.PushBack( thePlayer.SetAnimationSpeedMultiplier( animspeedmult_dodge_val ) );
					//theGame.witcherLog.AddMessage("DODGE SPEED  = " + animspeedmult_dodge_val );
				}
			
				theGame.GetEntitiesByTag('spells_dodge_effect',entities);
				for( i=0; i<entities.Size(); i+=1 )
				{
					entities[i].RemoveTag('spells_dodge_effect');
					entities[i].StopAllEffects();
					entities[i].DestroyAfter(5);
				} 	
			
				templatename = "dlc\magicspellsrev\data\entities\blood_moon_dodge.w2ent";
				dodge_effect = theGame.CreateEntity( (CEntityTemplate)LoadResource( templatename, true ), thePlayer.GetWorldPosition() );
				dodge_effect.AddTag('spells_dodge_effect');
				dodge_effect.PlayEffect('blood_cloud');
				
				templatename = "dlc\magicspellsrev\data\entities\blood_moon_dodge_start_end.w2ent";
				dodge_blood_add = theGame.CreateEntity( (CEntityTemplate)LoadResource( templatename, true ), thePlayer.GetWorldPosition(), thePlayer.GetWorldRotation() );
				dodge_blood_add.PlayEffect('blood');
				dodge_blood_add.StopAllEffectsAfter(0.5);
				dodge_blood_add.DestroyAfter(3);
				
				thePlayer.SoundEvent("monster_dettlaff_vampire_movement_whoosh_med");
				thePlayer.SetVisibility ( false );
				thePlayer.SetImmortalityMode( AIM_Invulnerable, AIC_Combat );
				thePlayer.SetCanPlayHitAnim(false);
				thePlayer.AddBuffImmunity_AllNegative('god_spells', true);
				thePlayer.EnableCharacterCollisions(false);
				
				AddTimer( 'special_dodge_actual', 0.0001, true );
				
				dodge_lock = true;
				
				AddTimer( 'special_dodge_end_safelock', 3 );
			}
		}
		else
		if ( GetWitcherPlayer().GetHorseManager().IsItemEquippedByName( 'assassin_tome' ) )
		{
			if ( !theSound.SoundIsBankLoaded("monster_dettlaff_vampire.bnk") )
			{
				theSound.SoundLoadBank( "monster_dettlaff_vampire.bnk", false );
			}
		
			if ( !dodge_lock )
			{
				if ( animspeedmult_dodge.Size() == 0 )
				{
					animspeedmult_dodge_val = 1.5;
					if ( other_speed_mult !=0 )
					{
						theGame.GetEntityByTag('storm_eye_effect').DestroyEffect('storm_eye');
						animspeedmult_dodge_val += other_speed_mult - 1;
					}
				
					animspeedmult_dodge.PushBack( thePlayer.SetAnimationSpeedMultiplier( animspeedmult_dodge_val ) );
					//theGame.witcherLog.AddMessage("DODGE SPEED  = " + animspeedmult_dodge_val );
				}
			
				theGame.GetEntitiesByTag('spells_dodge_effect',entities);
				for( i=0; i<entities.Size(); i+=1 )
				{
					entities[i].RemoveTag('spells_dodge_effect');
					entities[i].StopAllEffects();
					entities[i].DestroyAfter(5);
				} 	
				
				templatename = "dlc\magicspellsrev\data\entities\assassin_dodge.w2ent";
				dodge_effect = theGame.CreateEntity( (CEntityTemplate)LoadResource( templatename, true ), thePlayer.GetWorldPosition() );
				dodge_effect.AddTag('spells_dodge_effect');
				dodge_effect.PlayEffect('assassin_smoke');
				dodge_effect.PlayEffect('assassin_smoke_begin');dodge_effect.PlayEffect('assassin_smoke_begin');
				
				thePlayer.SoundEvent("monster_dettlaff_vampire_movement_whoosh_med");
				thePlayer.SetVisibility ( false );
				thePlayer.SetImmortalityMode( AIM_Invulnerable, AIC_Combat );
				thePlayer.SetCanPlayHitAnim(false);
				thePlayer.AddBuffImmunity_AllNegative('god_spells', true);
				thePlayer.EnableCharacterCollisions(false);
				
				AddTimer( 'special_dodge_actual', 0.0001, true );
				
				dodge_lock = true;
				
				AddTimer( 'special_dodge_end_safelock', 3 );
				
				if( theInput.IsActionPressed( 'CbtRoll' ) )
				{
					AddTimer( 'special_dodge_assassin_add_effect', 0.3 );
				}
			}
		}
	}
	timer function special_dodge_assassin_add_effect ( time : float , id : int )
	{
		dodge_effect.PlayEffect('assassin_smoke');
	}
	
	timer function special_dodge_actual ( time : float , id : int )
	{
		if ( theGame.GetEntityByTag( 'spells_dodge_effect' ) )
		{
			theGame.GetEntityByTag( 'spells_dodge_effect' ).TeleportWithRotation( thePlayer.GetWorldPosition(), thePlayer.GetWorldRotation() );
		}
		else
		{
			RemoveTimer('special_dodge_actual');
		}
	}
	
	function special_dodges_cancel()
	{
		dodge_lock = false;
		AddTimer('cancel_special_dodge', 0.3 );
	}
	timer function cancel_special_dodge ( time : float , id : int )
	{
		if ( !dodge_lock )
		{
			special_dodge_end();
		}
	}
	
	function special_dodge_end()
	{
		AddTimer('cancel_blood_dodge_timer', 0.2 );
		
		dodge_effect.StopEffect('blood_cloud');
		dodge_effect.PlayEffect('assassin_smoke_end');
		
		RemoveTimer( 'special_dodge_end_safelock' );
		
		reset_dodge_speed_spells();
		
		if ( GetWitcherPlayer().GetHorseManager().IsItemEquippedByName( 'vampire_tome' ) )
		{
			templatename = "dlc\magicspellsrev\data\entities\blood_moon_dodge_start_end.w2ent";
			dodge_blood_add = theGame.CreateEntity( (CEntityTemplate)LoadResource( templatename, true ), thePlayer.GetWorldPosition() );
			dodge_blood_add.CreateAttachment( theGame.GetEntityByTag( 'spells_dodge_effect' ) );
			dodge_blood_add.PlayEffect('blood');
			dodge_blood_add.StopAllEffectsAfter(0.5);
			dodge_blood_add.DestroyAfter(3);
		}
	}
	
	timer function cancel_blood_dodge_timer ( time : float , id : int )
	{
		if ( !dodge_lock )
		{
			theGame.GetEntitiesByTag('spells_dodge_effect',entities);
			for( i=0; i<entities.Size(); i+=1 )
			{
				entities[i].StopAllEffects();
				entities[i].DestroyAfter(5);
			} 	
			
			thePlayer.SetVisibility ( true );
			thePlayer.SetImmortalityMode( AIM_None, AIC_Combat );	
			thePlayer.SetCanPlayHitAnim(true);
			thePlayer.RemoveBuffImmunity_AllNegative('god_spells');
			if( !is_inside_energy && !is_inside_veil )
			{
				thePlayer.EnableCharacterCollisions(true);
			}
			
		}
	}
	
	timer function special_dodge_end_safelock ( time : float , id : int )
	{
		dodge_lock = false;
		//theGame.witcherLog.AddMessage("Dodge End SAFELOCK");
		special_dodge_end();
	}
	
	function reset_dodge_speed_spells()
	{
		for( i=0; i<animspeedmult_dodge.Size(); i+=1 )
		{
			thePlayer.ResetAnimationSpeedMultiplier( animspeedmult_dodge[i] );
		}
		animspeedmult_dodge.Clear();
	}
	
	timer function assassin_check_for_attacks ( time : float , id : int )
	{
	
		if ( is_holding_sword_spells() && thePlayer.GetCurrentStateName() != 'CombatFists' && thePlayer.IsInCombatAction() 
			&& ( thePlayer.GetCombatAction() == EBAT_LightAttack || thePlayer.GetCombatAction() == EBAT_HeavyAttack ) )
		{
			if ( animspeedmult_attack.Size() == 0 )
			{
				animspeedmult_attack_val = 1 + MinF( 0.5, ( get_spellpower_spells( false, S_Magic_4 ) * 0.2 ) );
				if ( other_speed_mult !=0 )
				{
					animspeedmult_attack_val += other_speed_mult - 1;
				}
				animspeedmult_attack.PushBack( thePlayer.SetAnimationSpeedMultiplier( animspeedmult_attack_val ) );
				
				//theGame.witcherLog.AddMessage("ATTACK SPEED  = " + animspeedmult_attack_val );
			}
		}
		else
		{
			reset_att_speed_spells();
		}
		
		if ( !thePlayer.HasBuff( EET_AssassinBless ) )
		{
			reset_att_speed_spells();
			//theGame.witcherLog.AddMessage("TIMER REMOVED");
			RemoveTimer( 'assassin_check_for_attacks' );
		}
	}
	function reset_att_speed_spells()
	{
		for( i=0; i<animspeedmult_attack.Size(); i+=1 )
		{
			thePlayer.ResetAnimationSpeedMultiplier( animspeedmult_attack[i] );
		}
		animspeedmult_attack.Clear();
	}
	
	timer function remove_horizon_spell ( time : float , id : int )
	{
		thePlayer.RemoveBuff( EET_Invisibilityspell );
	}
	
	function set_other_speed_mult( val : float )
	{
		other_speed_mult = val;
		
		if ( val == 0 )
		{
			reset_att_speed_spells();
			reset_dodge_speed_spells();
		}
	}
	
	
	function show_spell_tooltip()
	{
		var text 		: string;
		var notificationData : W3NotificationData;
	
		manual_aim_spells.Clear();
	
		process_items__tooltip( text );
		
		theGame.GetGuiManager().ShowNotification( text, 9000000 );
	}
	
	function show_spell_advanced_tooltip()
	{
		var text 				: string;
		
		closetooltip();
		
		manual_aim_spells.Clear();
	
		//if ( collect_spell_info( chosenString, text) )
		collect_spell_info( chosenString, text);
		{
			//TutorialMessagesEnable(true);
			//theGame.GetTutorialSystem().TutorialStart(false);	
			messageSpells = new W3TutorialPopupData in theGame;
			messageSpells.managerRef = theGame.GetTutorialSystem();
			messageSpells.scriptTag = 'aaa';
			messageSpells.duration = -1;
			messageSpells.autosize = false;
			messageSpells.canBeShownInMenus = true;
			messageSpells.posX = 0.01;
			messageSpells.posY = -0.07;
		
			//theGame.ClosePopup( 'TutorialPopup');
		
			messageSpells.messageText = text;
			theGame.RequestPopup( 'TutorialPopup',  messageSpells );
		}
		
		/*
		
		if (AdvPopupData)
		{
			delete AdvPopupData;
		}
		
		AdvPopupData = new BookPopupFeedback in theGame.GetGuiManager();
		AdvPopupData.SetMessageTitle( "SPELLS" );
		AdvPopupData.SetMessageText( text );
		AdvPopupData.singleBookMode = false;

		theGame.RequestMenu('PopupMenu', AdvPopupData);
		
		*/
		
	}
	
	
	timer function safelock_reset_state ( time : float , id : int )
	{
		PushState('Vigil_Dreaming');
		//theGame.witcherLog.AddMessage("vigil dreaming safelock");
	}
	
}